{smcl}
{* 16aug2016}{...}
{cmd:help textreg_predict}{right: ({browse "http://www.stata-journal.com/":SJxx-x: dm00xx})}
{hline}

{title:Title}

{p2colset 5 20 22 2}
{p2col :{hi:textreg_predict} {hline 2} Predict Outcome based on Text Regression Model}{p_end}
{p2colreset}{...}


{title:Syntax}

{p 8 17 2}
{cmd:textreg_predict} X {cmd:using} filename [{cmd:,} {it:options}]


{synoptset 30 tabbed}{...}
{synopthdr}
{synoptline}

{syntab:Options}

{synopt :{opth n:ame_new_var(strings:string)}} specifies the name of the new variable. {p_end}
{synopt :{opt s:tem}} specifies if the words should be stemmed.{p_end}
{synopt :{opth stem_lang:(strings:string)}} specifies the language of the stemmer. {p_end}

{synoptline}

{pstd}See {help textreg_predict##Options:{it:Options}} for details on specifying options.

 
{title:Description} 

{p 4 4 2} {cmd:textreg_predict} allows to predict an outcome based on text regression model trained with {cmd:textreg_train}.


{p 4 4 2} The {cmd:textreg_predict} generates a new variable which contains the prediction of the text regression.

{marker Options}{...}


{title:Options}

{phang} {cmd:name_new_var(}{it:integer}{cmd:)} specifies the name for the prediction from
the text regression model. The default is {cmd:name_new_var(}{it:"predict_"}{cmd:)}.

{phang} {cmd:stem} specifies if the words should be stemmed before estimation of 
the text regression model. This will reduce the words to their morphological roots
(e.g., walked to walk). The option should be specified if the pre-trained text regression
model uses stemming.

{phang} {cmd:stem_lang(}{it:string}{cmd:)} specifies the language of the text strings.
For a list of supported languages see https://www.nltk.org/_modules/nltk/stem/snowball.html.

{title:Remarks}

{pstd} To run {cmd: textreg_predict} the user needs to specify the string variable (X) on which the prediction should be based. 


{title:Examples}

{p 4 8 2}{cmd:. textreg_predict} text {cmd:using} "$path/Models/textreg_model.pkl" , name_new_var("prediction") {p_end}




{title:Authors}

{pstd}Carlo Schwarz{p_end}
{pstd}Bocconi University{p_end}
{pstd}Italy{p_end}
{pstd}{browse "www.carloschwarz.eu"}{p_end}
{pstd}carlo.schwarz@unibocconi.it{p_end}



{title:Also see}  

{p 4 14 2}
Article:  {it:Stata Journal}, volume x, number x: {browse "http://www.stata-journal.com/":dm00xx}

